/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.apps.taskman.pa.PADataFieldListCellRenderer;
import filenet.vw.apps.taskman.pa.PADataFieldWizard;
import filenet.vw.apps.taskman.pa.PADataFieldsNode;
import filenet.vw.apps.taskman.pa.peconnection.PEExposedLogField;
import filenet.vw.apps.taskman.pa.peconnection.PEExposedLogFields;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardControl;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardPanel;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PASelectEventLogFieldPanel
extends JPanel
implements IVWTaskWizardPanel,
IVWTaskWizardControl,
KeyListener {
    PADataFieldWizard m_wizard = null;
    PADataFieldsNode m_node = null;
    JComboBox m_fieldCombo = null;
    JTextField m_uniqueName = null;
    JTextField m_fieldType = null;
    JCheckBox m_showSystemFields = null;
    String m_fieldName = null;
    int m_nFieldType = -1;
    PEExposedLogFields m_logFields = null;
    private static final int MAX_FIELD_NAME_LENGTH = 128;

    public PASelectEventLogFieldPanel(PADataFieldWizard wizard) throws Exception {
        this.m_logFields = wizard.getDataFieldsNode().getEventLogFields();
        this.m_wizard = wizard;
        this.m_node = wizard.getDataFieldsNode();
        this.initLayout();
        this.updateControlsWithSelectedField();
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public int getFieldType() {
        return this.m_nFieldType;
    }

    public String getUniqueName() {
        return this.m_uniqueName.getText().trim();
    }

    public void performValidation() throws Exception {
        String uniqueName = this.getUniqueName();
        if (this.m_fieldCombo.getSelectedIndex() == -1) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.PEEventLogFieldNotSelected", "A Process Engine event log field must be selected.");
        }
        if (uniqueName.equals("")) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.UniqueNameMustBeSpecified", "A unique name must be specified.");
        }
        if (!(!this.m_wizard.isNewDataField() && uniqueName.equals(this.m_wizard.getDataFieldNode().getName()) || this.m_node.isNameUnique(uniqueName))) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.NameIsNotUnique", "The name \"{0}\" has already been used.  Enter a unique name.", uniqueName);
        }
        if (uniqueName.length() > 128) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.UniqueNameToLong", "The maximun length for a unique name is {0} characters.", new Integer(128));
        }
        boolean bValidName = true;
        if (!Character.isLetter(uniqueName.charAt(0))) {
            bValidName = false;
        } else {
            for (int i = 0; i < uniqueName.length(); ++i) {
                if (Character.isLetterOrDigit(uniqueName.charAt(i)) || uniqueName.charAt(i) == '_') continue;
                bValidName = false;
            }
        }
        if (!bValidName) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.InvalidUniqueNameSyntax", "The unique name must begin with a letter and contain only letters, numbers, or underscores.");
        }
        if (this.isReservedWord(uniqueName)) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.CannotUseReservedWord", "The term ''{0}'' is reserved for Case Analyzer internal use and cannot be used as the unique name of a data field.", uniqueName);
        }
    }

    public String getInstructions() {
        return VWResource.SelectProcessEngineField;
    }

    public String getHelpPath() {
        return VWHelp.Help_Process_TaskManager + "pa_data_fields.htm";
    }

    public void refresh() {
    }

    public boolean allowButtonToBeEnabled(int button) {
        if (button == 1) {
            return this.getUniqueName().length() > 0;
        }
        return true;
    }

    public void keyReleased(KeyEvent evt) {
        if (this.m_wizard != null) {
            this.m_wizard.updateButtonState();
        }
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getPEFieldPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(20, 0, 0, 0);
        this.add((Component)this.getUniqueNamePanel(), c);
    }

    private JPanel getPEFieldPanel() {
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.ProcessEngineEventLogField, 0);
        JPanel panel = borderPanel.getClientPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        boolean defaultIncludeSystemFields = this.m_wizard.getDataFieldsNode().getShowSystemFields();
        if (!this.m_wizard.isNewDataField() && this.m_wizard.getDataFieldNode().getFieldName().startsWith("F_")) {
            defaultIncludeSystemFields = true;
        }
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.Field)), c);
        this.m_fieldCombo = new JComboBox();
        this.m_fieldCombo.setRenderer(new PADataFieldListCellRenderer());
        this.updateFieldCombo(defaultIncludeSystemFields);
        this.m_fieldCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    // empty if block
                }
                PASelectEventLogFieldPanel.this.updateControlsWithSelectedField();
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 20);
        panel.add((Component)this.m_fieldCombo, c);
        this.m_showSystemFields = new JCheckBox(VWResource.ShowSystemFields, true);
        this.m_showSystemFields.setSelected(defaultIncludeSystemFields);
        this.m_showSystemFields.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PASelectEventLogFieldPanel.this.updateFieldCombo(PASelectEventLogFieldPanel.this.m_showSystemFields.isSelected());
                PASelectEventLogFieldPanel.this.updateControlsWithSelectedField();
                PASelectEventLogFieldPanel.this.m_wizard.getDataFieldsNode().setShowSystemFields(PASelectEventLogFieldPanel.this.m_showSystemFields.isSelected());
            }
        });
        c.gridx = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 20);
        panel.add((Component)this.m_showSystemFields, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.FieldType)), c);
        this.m_fieldType = new JTextField();
        this.m_fieldType.setEditable(false);
        this.m_fieldType.setBorder(null);
        c.gridx = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 5);
        panel.add((Component)this.m_fieldType, c);
        return borderPanel;
    }

    private JPanel getUniqueNamePanel() {
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.ProcessAnalyzerUniqueName, 0);
        JPanel panel = borderPanel.getClientPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.UniqueName)), c);
        this.m_uniqueName = new JTextField();
        this.m_uniqueName.addKeyListener(this);
        if (!this.m_wizard.isNewDataField()) {
            this.m_uniqueName.setText(this.m_wizard.getDataFieldNode().getName());
        }
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 20);
        panel.add((Component)this.m_uniqueName, c);
        c.gridx = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 20);
        panel.add(Box.createHorizontalStrut((int)this.m_showSystemFields.getPreferredSize().getWidth()), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add(Box.createHorizontalStrut(0), c);
        return borderPanel;
    }

    void updateControlsWithSelectedField() {
        Object item = this.m_fieldCombo.getSelectedItem();
        if (item != null) {
            PEExposedLogField field = (PEExposedLogField)item;
            try {
                this.m_fieldName = field.getName();
                this.m_nFieldType = field.getFieldType();
                this.m_fieldType.setText(VWFieldType.getLocalizedString(this.m_nFieldType));
                if (this.m_wizard.isNewDataField()) {
                    StringBuffer nameBuffer = new StringBuffer(field.getName());
                    if (nameBuffer.length() > 128) {
                        nameBuffer.setLength(128);
                    }
                    this.m_uniqueName.setText(nameBuffer.toString());
                }
            }
            catch (VWException vWException) {}
        } else {
            this.m_fieldType.setText("");
            if (this.m_wizard.isNewDataField()) {
                this.m_uniqueName.setText("");
            }
            this.m_fieldName = null;
            this.m_nFieldType = -1;
        }
    }

    void updateFieldCombo(boolean includeSystem) {
        this.m_fieldCombo.removeAllItems();
        if (this.m_wizard.isNewDataField()) {
            this.m_fieldCombo.setModel(new DefaultComboBoxModel<PEExposedLogField>(this.m_logFields.getFields(includeSystem)));
        } else {
            PEExposedLogField[] fields = this.m_logFields.getFields(includeSystem, this.m_wizard.getDataFieldNode().getFieldType());
            this.m_fieldCombo.setModel(new DefaultComboBoxModel<PEExposedLogField>(fields));
            PEExposedLogField field = this.getField(this.m_wizard.getDataFieldNode().getFieldName(), fields);
            if (field != null) {
                this.m_fieldCombo.setSelectedItem(field);
            }
        }
    }

    private PEExposedLogField getField(String name, PEExposedLogField[] fields) {
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(name)) continue;
                return fields[i];
            }
        }
        return null;
    }

    private boolean isReservedWord(String word) {
        if (word.equalsIgnoreCase("Queue")) {
            return true;
        }
        if (word.equalsIgnoreCase("Status")) {
            return true;
        }
        if (word.equalsIgnoreCase("User")) {
            return true;
        }
        if (word.equalsIgnoreCase("Workflow")) {
            return true;
        }
        if (word.equalsIgnoreCase("Time")) {
            return true;
        }
        if (word.equalsIgnoreCase("Incoming")) {
            return true;
        }
        if (word.equalsIgnoreCase("Outgoing")) {
            return true;
        }
        return word.equalsIgnoreCase("Workload");
    }

    public boolean skipThisPanel() {
        return !this.m_wizard.IsSourcePESelected();
    }
}

